clear all;
close all;
clc;

% ABS via line search-based ESC

% define the global variable
global A B InvWc x0 lambdas t0 t1 c R m B N; 
global usave tsave

usave=[]; tsave=[];


% Consider a state feedback linearizable nonlinear systemes
% m x1dot=-N*mu
% I x2dot=-B*x2+N*R*mu-u
%
% After feedback linearzation, the resulting system will behave as
% following (A,B) in terms of new state z

% system parameter
c=1;
R=0.3;
m=400;
B=0.01;
N=m*9.8;
I=1;
 
lambdastar=0.25;

% stable system matrix
A=-c;
B=1;  

t0=0;  % start time
t1=7;  % end time
dt=0.5;  % regulation time bewteen each step
flag=1; 
num=t1/dt;  % number of search steps
%initial condition of the state 
x0=[100/3;400/3.6];   
xhat(:,1)=x0(1:2);   % real regulated state
lambdasr(1)=(x0(1)-R*x0(2))/x0(1);   % desired regulated state
Nx=0;          % counter of state
Nu=0;          % counter of control
Nt=0;          % counter of time
rho=0.8;       % constant in Armijo condition
w=0.8;         % step size retraction factor
hk=0.3;
eta=0.2;
% hk=0.255;
% eta=0.1;
 
TIME=6
for ind=1:num 
    t1=t0+dt;  
    if t1>TIME
        break;
    end
    % steep descent algorithm    
    x1=x0(1);  % current location
    x2=x0(2);    
    lambda=(x1-R*x2)/x1;    
    
    % Banana Function
    [f,grad,H]=mu(lambda);  % obtain function value and gradient
    
    %-----------------------------------------------------------
    % LINE SEARCH METHOD
    %-----------------------------------------------------------
    
%     perform an inexact line search satifiying Armijo condition
%     a maximum limit of 50 trial of step size is posted
%     ideally we should impose such a limitation
%     alpha=0.1; 
%     for k=1:100     
%        if mu(lambda+alpha*(-grad))<=f+rho*alpha*(-grad)*grad;           
%           break;
%        end
%        alpha=w*alpha; 
%     end   
    
    % Exact line search
    alpha=(lambdastar-lambda)/(-grad);

    % obtained step length   
    lambdas=lambda-alpha*grad;   % ideal search destination
    lambdasr(end+1)=lambda;     
    
    % control gramian
    Wc=(1-exp(-2*c*(t1-t0)))/(2*c);
    InvWc=inv(Wc);
    
    % solving the ode
    tspan=[t0 t1];  
    rand('state',0);
    [t,x]=ode23('abs_steep_derivatives',tspan,x0);    
    
    for i=1:length(t)
        idx = find(tsave-t(i)==0);
        u(i)=usave(idx(length(idx)));
    end;

    
    % update
    x0=x(end,:)
    xhat(:,end+1)=x0(1:2);   % real regulated state
    x0=x0.'+0*rand(1);  % disturbing the regulated state
    
    t0=t1;
    xreal(Nx+1:Nx+length(x),:)=x;
    Nx=length(xreal)-1;
    ureal(Nu+1:Nu+length(u))=u;
    Nu=length(ureal)-1;    
    treal(Nt+1:Nt+length(t))=t;
    Nt=length(treal)-1;
    usave=[]; tsave=[];
end

% trajectory of the states
x1=xreal(:,1);
x2=xreal(:,2);
lambda=(x1-R.*x2)./x1;

% trajectory of the objective function
y=-mu(lambda);

figure 
plot(treal,y,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('output','FontSize',18,'FontWeight','bold');
title('Friction Force Coefficient','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%saveas(gcf,'abs_output_ls.eps','psc2');

figure 
plot(treal,lambda,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('\lambda','FontSize',18,'FontWeight','bold');
title('Slip','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%saveas(gcf,'abs_lambda_ls.eps','psc2');


figure
plot(treal,x1,treal,x2,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('states','FontSize',18,'FontWeight','bold');
legend('Linear Velocity','Angular Velocity');
title('Linear Velocity and Angular Velocity','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%axis([0 10 -1 1]
%saveas(gcf,'abs_state_ls.eps','psc2');

figure
plot(treal,ureal(1:length(treal)),'LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('Input','FontSize',18,'FontWeight','bold');
title('Braking Torque','FontSize',18,'FontWeight','bold');
grid on;  set(gca,'FontSize',12,'FontWeight','bold');  
%saveas(gcf,'abs_control_ls.eps','psc2');